//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ParseNode.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:26:29 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Aug 12 13:26:00 2015
// Update Count     : 36
// 

#include "ParseNode.h"
using namespace std;

// Builder
int ParseNode::indent_by = 4;

ParseNode::ParseNode() : next( 0 ) {};
ParseNode::ParseNode( const string *name ) : name( *name ), next( 0 ) { delete name; }
ParseNode::ParseNode( const string &name ) : name( name ), next( 0 ) { }

ParseNode::~ParseNode() {
	delete next;
};

ParseNode *ParseNode::get_link() const {
	return next;
}

ParseNode *ParseNode::get_last() {
	ParseNode *current = this;

	while ( current->get_link() != 0 )
	current = current->get_link();

	return current;
}

ParseNode *ParseNode::set_link( ParseNode *next_ ) {
	if ( next_ == 0 ) return this;

	get_last()->next = next_;

	return this;
}

void ParseNode::print( std::ostream &os, int indent ) const {}


void ParseNode::printList( std::ostream &os, int indent ) const {
	print( os, indent );

	if ( next ) {
		next->printList( os, indent );
	} // if
}

ParseNode &ParseNode::operator,( ParseNode &p ) {
	set_link( &p );

	return *this;
}

ParseNode *mkList( ParseNode &pn ) {
	// it just relies on `operator,' to take care of the "arguments" and provides a nice interface to an awful-looking
	// address-of, rendering, for example (StatementNode *)(&(*$5 + *$7)) into (StatementNode *)mkList(($5, $7))
	// (although "nice" is probably not the word)
	return &pn;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
