//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ParseNode.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:26:29 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Aug 15 14:49:06 2016
// Update Count     : 99
// 

#include "ParseNode.h"
using namespace std;

// Builder
int ParseNode::indent_by = 4;

ParseNode::ParseNode() : next( 0 ) {};
ParseNode::ParseNode( const string *name ) : name( *name ), next( 0 ) { delete name; }
ParseNode::ParseNode( const string &name ) : name( name ), next( 0 ) { }

ParseNode::~ParseNode() {
	delete next;
};

ParseNode *ParseNode::get_last() {
	ParseNode *current = this;

	while ( current->get_next() != 0 )
	current = current->get_next();
	return current;
}

ParseNode *ParseNode::set_last( ParseNode *next_ ) {
	if ( next_ != 0 ) get_last()->next = next_;
	return this;
}

void ParseNode::print( std::ostream &os, int indent ) const {}


void ParseNode::printList( std::ostream &os, int indent ) const {
	print( os, indent );

	if ( next ) {
		next->printList( os, indent );
	} // if
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
