//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FixFunction.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 17:02:08 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:45:55 2017
// Update Count     : 4
//

#pragma once

#include "Common/PassVisitor.h" // for PassVisitor
#include "SynTree/SynTree.h"    // for Types

namespace SymTab {
	/// Replaces function and array types by equivalent pointer types.
	class FixFunction : public WithShortCircuiting {
		typedef Mutator Parent;
	  public:
		FixFunction();

		void premutate(FunctionDecl *functionDecl);
		DeclarationWithType* postmutate(FunctionDecl *functionDecl);

		Type * postmutate(ArrayType * arrayType);

		void premutate(ArrayType * arrayType);
		void premutate(VoidType * voidType);
		void premutate(BasicType * basicType);
		void premutate(PointerType * pointerType);
		void premutate(StructInstType * aggregateUseType);
		void premutate(UnionInstType * aggregateUseType);
		void premutate(EnumInstType * aggregateUseType);
		void premutate(TraitInstType * aggregateUseType);
		void premutate(TypeInstType * aggregateUseType);
		void premutate(TupleType * tupleType);
		void premutate(VarArgsType * varArgsType);
		void premutate(ZeroType * zeroType);
		void premutate(OneType * oneType);

		bool isVoid;
	};

	bool fixFunction( DeclarationWithType *& );
} // namespace SymTab

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
