set terminal pdf color enhanced size 6.0in,3.0in font "Times,17"

INDIR="build"
OUTDIR="build"

set macros
set output OUTDIR."/plot-list-zoomout-noshuf.pdf"

set grid
set key top left
set logscale x
set xrange [10:*]
#set logscale y
#set yrange [32:*];
set xlabel "List length (item count)" offset 2,0
set ylabel "Duration (ns)"
set linetype 3 dashtype 2
set linetype 4 dashtype 2

plot INDIR."/plot-list-zoomout-noshuf.dat" \
       i 2 using 1:2 title "STL" with points lt rgb "forest-green"	pt  3 ps 1 lw 1, \
    '' i 0 using 1:2 title "intrusives" with points lt rgb "black"	pt  1 ps 1 lw 1, \
    '' i 1 using 1:2 notitle with points lt rgb "black"	    pt  1 ps 1 lw 1, \
    '' i 3 using 1:2 notitle with points lt rgb "black"	pt  1 ps 1 lw 1, \
    '' i 4 using 1:2 notitle with points lt rgb "black"	pt  1  ps 1 lw 1
