set terminal pdf color enhanced size 6.0in,3.0in font "Times,17"

INDIR="build"
OUTDIR="build"

set macros
set output OUTDIR."/plot-list-zoomin-rel.pdf"

set grid
set key top right
set logscale x 2
set logscale y 2
set yrange [0.85:1.33];
set ytics ( \
   "+40%%" 1.666666667, \
   "+30%%" 1.428571429, \
   "+20%%" 1.25, \
   "+10%%" 1.111111111, \
   "0" 1, \
   "-10%%" 0.909090909, \
   "-20%%" 0.833333333, \
   "-30%%" 0.769230769, \
)
set xrange [0.75:128];
set xlabel "List length (item count)" offset 2,0
set ylabel "Duration (tailq-Relative)" offset -1.0,0
set errorbars 2.0

# Draw axis-like line at speedup=0% (y=1.0)
set arrow from graph 0, first 1 to graph 1, first 1 nohead lt -1 lw 2

plot INDIR."/plot-list-zoomin-rel.dat" \
       i 0 using ($1 * 0.98):8:4:5 title columnheader(1) with yerrorbars lt rgb "blue" 	      pt  7  ps 0.85 lw 1, \
    '' i 9 using ($1 * 0.94):8:4:5 title columnheader(1) with yerrorbars lt rgb "dark-orange"	pt  9  ps 0.75 lw 1, \
    '' i 8 using ($1 * 1.02):8:4:5 title columnheader(1) with yerrorbars lt rgb "magenta"	      pt  11 ps 0.85 lw 1, \
    '' i 7 using ($1 * 1.06):8:4:5 title columnheader(1) with yerrorbars lt rgb "purple"	      pt  13 ps 1.0  lw 1
