set terminal pdf color enhanced size 6.0in,3.0in font "Times,17"

INDIR="build"
OUTDIR="build"

set macros
set output OUTDIR."/plot-list-zoomin-abs.pdf"

set grid
set key top right
set logscale x 2
set logscale y
set yrange [5:12.5];
set ytics (6,7,8,9,10,11,12)
set xrange [0.75:128];
set xlabel "List length (item count)" offset 2,0
set ylabel "Duration (ns)" offset -1.0,0
set errorbars 2.0

plot INDIR."/plot-list-zoomin-abs.dat" \
       i 0 using ($1 * 0.98):8:4:5 title columnheader(1) with yerrorbars lt rgb "blue" 	      pt  7  ps 0.85 lw 1, \
    '' i 9 using ($1 * 0.94):8:4:5 title columnheader(1) with yerrorbars lt rgb "dark-orange"	pt  9  ps 0.75 lw 1, \
    '' i 8 using ($1 * 1.02):8:4:5 title columnheader(1) with yerrorbars lt rgb "magenta"	      pt  11 ps 0.85 lw 1, \
    '' i 7 using ($1 * 1.06):8:4:5 title columnheader(1) with yerrorbars lt rgb "purple"	      pt  13 ps 1.0  lw 1
