set terminal pdf color enhanced size 6.0in,3.0in font "Times,17"

INDIR="build"
OUTDIR="build"
SRCDIR="plots"

set output OUTDIR.'/plot-list-cmp-exout.pdf'

set bmargin 6  # extra room at bottom for multiline x axis labels

set xrange [1:9]
set xlabel "Operation (movement / polarity / accessor)"  offset 0,-2,0
set xtics offset 4.2,0

set logscale y 2
set yrange [0.75:1.8];
set ytics ( \
   "+40%%" 1.666666667, \
   "+30%%" 1.428571429, \
   "+20%%" 1.25, \
   "+10%%" 1.111111111, \
   "0" 1, \
   "-10%%" 0.909090909, \
   "-20%%" 0.833333333, \
   "-30%%" 0.769230769, \
)
set ylabel "Duration (tailq-Relative)" offset -1.0,0

# Draw axis-like line at speedup=0% (y=1.0)
set arrow from graph 0, first 1 to graph 1, first 1 nohead lt -1 lw 2

set grid
set key top center horizontal

BOXSPACING=0.25
BOXWIDTH=BOXSPACING * .88
set boxwidth BOXWIDTH absolute

NUM_FXS=3

offset(opNum, fxNum) = opNum + fxNum * BOXSPACING - (NUM_FXS+1) * BOXSPACING / 2 + 0.5

# One row, to plot one-off points
$Singleton <<EOD
0
EOD

# empty candlesticks for quantiles, then
# varyiously styled points for means, then
# x axis values, then
# legend symbol augmentation
plot INDIR.'/plot-list-cmp-exout.dat' \
        using ($2 == 1 ? (offset($1, $2)) : 1/0):10:9:13:12 title 'cfa-cfa' with candlesticks lt rgb "blue"	   , \
     '' using ($2 == 2 ? (offset($1, $2)) : 1/0):10:9:13:12 title 'upp-upp' with candlesticks lt rgb "dark-orange", \
     '' using ($2 == 3 ? (offset($1, $2)) : 1/0):10:9:13:12 title 'lq-list' with candlesticks lt rgb "purple"	, \
     '' using ($2 == 1 ? (offset($1, $2)) : 1/0):4          notitle         with points pt 7  lt rgb "blue"	   , \
     '' using ($2 == 2 ? (offset($1, $2)) : 1/0):4          notitle         with points pt 9  lt rgb "dark-orange", \
     '' using ($2 == 3 ? (offset($1, $2)) : 1/0):4          notitle         with points pt 13 lt rgb "purple"	, \
     SRCDIR.'/list-cmp-exout-meta.dat' \
        using 1:(-999):xtic(2) notitle with points, \
     $Singleton using (3.73):(1.69)                         notitle         with points pt 7  lt rgb "blue"	   , \
     $Singleton using (5.44):(1.69)                         notitle         with points pt 9  lt rgb "dark-orange", \
     $Singleton using (7.14):(1.69)                         notitle         with points pt 13 lt rgb "purple"
