
#
#     Save in UTF-8 encoding.
#


set terminal pdf color enhanced size 6.0in,3.0in font "Times,17"

INDIR="build"
OUTDIR="build"
SRCDIR="plots"

set output OUTDIR.'/plot-list-cfa-attrib-remelem.pdf'

set bmargin 6  # extra room at bottom for multiline x axis labels

set xrange [1:6]
set xlabel "Operation (movement / polarity / accessor)"  offset 0,-2,0
set xtics offset 4.2,0

set logscale y 2
set yrange [0.88:2.1];
set ytics ( \
   "+50%%" 2, \
   "+40%%" 1.666666667, \
   "+30%%" 1.428571429, \
   "+20%%" 1.25, \
   "+10%%" 1.111111111, \
   "0" 1, \
   "-10%%" 0.909090909, \
   "-20%%" 0.833333333, \
   "-30%%" 0.769230769, \
)
set ylabel "Duration (tailq-Relative)" offset -1.0,0

# Draw axis-like line at speedup=0% (y=1.0)
set arrow from graph 0, first 1 to graph 1, first 1 nohead lt -1 lw 2

set grid
set key top center horizontal

BOXSPACING=0.14
BOXWIDTH=BOXSPACING * .88
set boxwidth BOXWIDTH absolute

NUM_FXS=6

offset(opNum, fxNum) = opNum + fxNum * BOXSPACING - (NUM_FXS+1) * BOXSPACING / 2 + 0.5

# One row, to plot one-off points
$Singleton <<EOD
0
EOD

# empty candlesticks for quantiles, then
# varyiously styled points for means, then
# x axis values, then
# legend symbol augmentation
plot INDIR.'/plot-list-cfa-attrib-remelem.dat' \
        using ($2 == 1 ? (offset($1, $2)) : 1/0):10:9:13:12 title 'full'      with candlesticks lt        rgb "blue", \
     '' using ($2 == 2 ? (offset($1, $2)) : 1/0):10:9:13:12 title 'mand-head' with candlesticks lt        rgb "dark-goldenrod", \
     '' using ($2 == 3 ? (offset($1, $2)) : 1/0):10:9:13:12 title 'no-listed' with candlesticks lt        rgb "dark-salmon", \
     '' using ($2 == 4 ? (offset($1, $2)) : 1/0):10:9:13:12 title 'parity'    with candlesticks lt        rgb "gray40", \
     '' using ($2 == 5 ? (offset($1, $2)) : 1/0):10:9:13:12 title 'no-iter'   with candlesticks lt        rgb "dark-turquoise", \
     '' using ($2 == 6 ? (offset($1, $2)) : 1/0):10:9:13:12 title 'strip'     with candlesticks lt        rgb "red", \
     '' using ($2 == 1 ? (offset($1, $2)) : 1/0):4          notitle           with points pt 7  lt        rgb "blue", \
     '' using ($2 == 2 ? (offset($1, $2)) : 1/0):4:("◐")    notitle           with labels       textcolor rgb "dark-goldenrod" font "DejaVuSans-Bold,14", \
     '' using ($2 == 3 ? (offset($1, $2)) : 1/0):4:("◑")    notitle           with labels       textcolor rgb "dark-salmon"	 font "DejaVuSans-Bold,14", \
     '' using ($2 == 4 ? (offset($1, $2)) : 1/0):4          notitle           with points pt 6  lt        rgb "gray40", \
     '' using ($2 == 5 ? (offset($1, $2)) : 1/0):4          notitle           with points pt 3  lt        rgb "dark-turquoise", \
     '' using ($2 == 6 ? (offset($1, $2)) : 1/0):4          notitle           with points pt 15 lt        rgb "red", \
     SRCDIR.'/list-cfa-attrib-remelem-meta.dat' \
        using 1:(-999):xtic(2) notitle with points, \
     $Singleton using (2.7 ):(1.99)                         notitle           with points pt 7  lt        rgb "blue", \
     $Singleton using (2.7 ):(1.83):("◐")                   notitle           with labels       textcolor rgb "dark-goldenrod" font "DejaVuSans-Bold,14", \
     $Singleton using (3.85):(1.99):("◑")                   notitle           with labels       textcolor rgb "dark-salmon"    font "DejaVuSans-Bold,14", \
     $Singleton using (3.85):(1.83)                         notitle           with points pt 6  lt        rgb "gray40", \
     $Singleton using (5.1 ):(1.99)                         notitle           with points pt 3  lt        rgb "dark-turquoise", \
     $Singleton using (5.1 ):(1.83)                         notitle           with points pt 15 lt        rgb "red"
