// Cross a Try Statement with a Termination Handler
#include <chrono>
#include <cstdlib>
#include <exception>
#include <iostream>

using namespace std::chrono;

struct NotRaisedException : public std::exception {};

int main(int argc, char * argv[]) {
	unsigned int times = 1;
	if (1 < argc) {
		times = strtol(argv[1], nullptr, 10);
	}

	time_point<steady_clock> start_time = steady_clock::now();
	for (unsigned int count = 0 ; count < times ; ++count) {
		try {
			// ...
		} catch (NotRaisedException &) {
			// ...
		}
	}
	time_point<steady_clock> end_time = steady_clock::now();
	nanoseconds duration = duration_cast<nanoseconds>(end_time - start_time);
	std::cout << "Run-Time (ns): " << duration.count() << std::endl;
}
