//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Alternative.h --
//
// Author           : Richard C. Bilson
// Created On       : Sat May 16 23:45:43 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:36:36 2017
// Update Count     : 3
//

#pragma once

#include <iosfwd>             // for ostream
#include <list>               // for list

#include "Cost.h"             // for Cost
#include "TypeEnvironment.h"  // for TypeEnvironment

class Expression;

namespace ResolvExpr {
	struct Alternative;

	typedef std::list< Alternative > AltList;

	struct Alternative {
		Alternative();
		Alternative( Expression *expr, const TypeEnvironment &env, const Cost &cost );
		Alternative( Expression *expr, const TypeEnvironment &env, const Cost &cost, const Cost &cvtCost );
		Alternative( const Alternative &other );
		Alternative &operator=( const Alternative &other );
		Alternative( Alternative && other );
		Alternative &operator=( Alternative && other );
		~Alternative();

		void print( std::ostream &os, int indent = 0 ) const;

		Cost cost;
		Cost cvtCost;
		Expression *expr;
		TypeEnvironment env;
	};
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
