package main

import (
	"fmt"
	"time"
	"runtime"
	"sync"
	"os"
	"strconv"
)

var done bool = false;
var total_operations uint64 = 0
var Processors int = 1
var m sync.Mutex

var taskJoin chan int = make(chan int, 2)
var chain chan int = make(chan int, 2 )

func Task() {
	var count uint64 = 0 
	for {
		if done { break }
		<-chain
		chain<-0
		count++;
	}
	
	m.Lock()
	total_operations += count
	m.Unlock()
	taskJoin <- 0
}

func main() {
	switch len( os.Args ) {
		case 2:
			if os.Args[1] != "d" {							// default ?
				Processors, _ = strconv.Atoi( os.Args[1] )
			} // if
		case 1:											// use defaults
		default:
			fmt.Printf( "Invalid args" );
			os.Exit( 1 );
	} // switch
	runtime.GOMAXPROCS( Processors );

	taskJoin= make(chan int, Processors)
	chain= make(chan int, 2 * Processors )
	
	chain <- 0

	for i := 0; i < Processors; i++ {
		go Task()
	}
		
	// wait 10 seconds
	time.Sleep(time.Second * 10)
	// fmt.Println("prod done\n")
	done = true

	for i := 0; i < Processors; i++ {
		chain <- 0
	}
	for i := 0; i < Processors; i++ {
		<-taskJoin
	}

    fmt.Println(total_operations)
}