package main

import (
	"fmt"
	"time"
	"runtime"
)

var done bool = false;
var total_operations uint64 = 0

var taskJoin chan int = make(chan int, 2)

var ping chan int = make(chan int, 2 )
var pong chan int = make(chan int, 2 )

func Ping() {
	for {
		if done { break }
		pong <- 1
		<-ping
	}
	taskJoin <- 0
}

func Pong() {
	for {
		if done { break }
		<-pong
		ping <- 0
		total_operations++
	}
	taskJoin <- 0
}

func main() {
	runtime.GOMAXPROCS( 2 );

	go Ping()
	go Pong()
		
	// wait 10 seconds
	time.Sleep(time.Second * 10)
	// fmt.Println("prod done\n")
	done = true

	ping <- 2
	pong <- 2

	<-taskJoin
	<-taskJoin

    fmt.Println(total_operations)
}