//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AddVisit.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 16:14:32 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 12 17:46:33 2016
// Update Count     : 6
//

namespace SymTab {
	void addDecls( std::list< Declaration* > &declsToAdd, std::list< Statement* > &statements, std::list< Statement* >::iterator i );

	template< typename Visitor >
	inline void addVisitStatementList( std::list< Statement* > &statements, Visitor &visitor ) {
		for ( std::list< Statement* >::iterator i = statements.begin(); i != statements.end(); ++i ) {
			addDecls( visitor.get_declsToAdd(), statements, i );
			(*i)->accept( visitor );
		} // for
		addDecls( visitor.get_declsToAdd(), statements, statements.end() );
	}

	template< typename Visitor >
	inline void addVisit(CompoundStmt *compoundStmt, Visitor &visitor) {
		addVisitStatementList( compoundStmt->get_kids(), visitor );
	}

	template< typename Visitor >
	inline void addVisit(SwitchStmt *switchStmt, Visitor &visitor) {
		addVisitStatementList( switchStmt->get_branches(), visitor );
		maybeAccept( switchStmt->get_condition(), visitor );
	}

	template< typename Visitor >
	void acceptAndAdd( std::list< Declaration * > &translationUnit, Visitor &visitor, bool addBefore ) {
		std::list< Declaration * >::iterator i = translationUnit.begin();
		while ( i != translationUnit.end() ) {
			(*i)->accept( visitor );
			std::list< Declaration * >::iterator next = i;
			next++;
			if ( ! visitor.get_declsToAdd().empty() ) {
				translationUnit.splice( addBefore ? i : next, visitor.get_declsToAdd() );
			} // if
			i = next;
		} // while
	}

} // namespace SymTab

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
