//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// assert.c --
//
// Author           : Thierry Delisle
// Created On       : Mon Nov 28 12:27:26 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jul 20 15:10:26 2017
// Update Count     : 2
//

#include <assert.h>
#include <stdarg.h>								// varargs
#include <stdio.h>								// fprintf
#include "libhdr/libdebug.h"

extern "C" {
	extern const char * __progname;						// global name of running executable (argv[0])

	#define CFA_ASSERT_FMT "Cforall Assertion error from program \"%s\" in \"%s\" at line %d in file \"%s\""

	// called by macro assert in assert.h
	void __assert_fail( const char *assertion, const char *file, unsigned int line, const char *function ) {
		__lib_debug_print_safe( CFA_ASSERT_FMT ".\n", __progname, function, line, file );
		abort();
	}

	// called by macro assertf
	void __assert_fail_f( const char *assertion, const char *file, unsigned int line, const char *function, const char *fmt, ... ) {
		__lib_debug_acquire();
		__lib_debug_print_nolock( CFA_ASSERT_FMT ": ", __progname, function, line, file );

		va_list args;
		va_start( args, fmt );
		__lib_debug_print_vararg( fmt, args );
		va_end( args );

		__lib_debug_print_nolock( "\n" );
		__lib_debug_release();
		abort();
	}
}

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
