//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ImplementationType.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 21:35:41 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:46:19 2017
// Update Count     : 3
//

#pragma once

class Type;

namespace SymTab {
class Indexer;

	Type *implementationType( Type *, const SymTab::Indexer &indexer );

	template< typename InputIterator, typename OutputIterator >
	void implementationTypeList( InputIterator begin, InputIterator end, OutputIterator out, const SymTab::Indexer &indexer ) {
		while ( begin != end ) {
			*out++ = implementationType( *begin++, indexer );
		} // while
	}
} // namespace SymTab

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
