//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// RemoveInit.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:40:11 2015
// Update Count     : 1
//

#ifndef REMOVE_INIT_H
#define REMOVE_INIT_H

#include <string>
#include <list>

#include "SynTree/SynTree.h"
#include "SynTree/Declaration.h"
#include "SynTree/Mutator.h"

namespace InitTweak {
	/// Adds assignment statements for polymorphic type initializers
	void tweak( std::list< Declaration * > translationUnit );

	class RemoveInit : public Mutator {
	  public:
		// RemoveInit();
		virtual ObjectDecl *mutate(ObjectDecl *objDecl);
		virtual CompoundStmt *mutate(CompoundStmt *compoundStmt);
	  protected:
		std::list< Statement* > stmtsToAddAfter;
		void mutateStatementList( std::list< Statement* > &statements );
	};
} // namespace 

#endif // GENPOLY_POLYMUTATOR_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
