//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LabelGenerator.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jun 23 12:18:34 2015
// Update Count     : 13
//

#include <iostream>
#include <sstream>

#include "LabelGenerator.h"

namespace ControlStruct {
	LabelGenerator *LabelGenerator::labelGenerator = 0;

	LabelGenerator *LabelGenerator::getGenerator() {
		if ( LabelGenerator::labelGenerator == 0 )
			LabelGenerator::labelGenerator = new LabelGenerator();

		return labelGenerator;
	}

	Label LabelGenerator::newLabel( std::string suffix ) {
		std::ostringstream os;
		os << "__L" << current++ << "__" << suffix;
		std::string ret = os.str();
		return Label( ret );
	}
} // namespace ControlStruct

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
