//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Type.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Dec 09 14:08:48 2015
// Update Count     : 4
//

#include "SynTree.h"
#include "Visitor.h"
#include "Type.h"
#include "Declaration.h"
#include "Common/utility.h"

const char *BasicType::typeNames[BasicType::NUMBER_OF_BASIC_TYPES] = {
	"_Bool",
	"char",
	"char",
	"unsigned char",
	"short",
	"short unsigned",
	"int",
	"unsigned int",
	"long int",
	"long unsigned int",
	"long long int",
	"long long unsigned int",
	"float",
	"double",
	"long double",
	"float _Complex",
	"double _Complex",
	"long double _Complex",
	"float _Imaginary",
	"double _Imaginary",
	"long double _Imaginary",
};

Type::Type( const Qualifiers &tq ) : tq( tq ) {}

Type::Type( const Type &other ) : tq( other.tq ) {
	cloneAll( other.forall, forall );
}

Type::~Type() {
	deleteAll( forall );
}

void Type::Qualifiers::print( std::ostream &os, int indent ) const {
	if ( isConst ) {
		os << "const ";
	} // if
	if ( isVolatile ) {
		os << "volatile ";
	} // if
	if ( isRestrict ) {
		os << "restrict ";
	} // if
	if ( isLvalue ) {
		os << "lvalue ";
	} // if
	if ( isAtomic ) {
		os << "_Atomic ";
	} // if
	if ( isAttribute ) {
		os << "__attribute(( )) ";
	} // if
}

void Type::print( std::ostream &os, int indent ) const {
	if ( ! forall.empty() ) {
		os << "forall" << std::endl;
		printAll( forall, os, indent + 4 );
		os << std::string( indent+2, ' ' );
	} // if
	tq.print( os, indent );
}

std::ostream & operator<<( std::ostream & out, Type * type ) {
	type->print( out );
	return out;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
