//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Parser.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 14:54:28 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 31 23:45:19 2015
// Update Count     : 4
// 

#include "Parser.h"
#include "TypedefTable.h"
#include "lex.h"
#include "parser.h"

// global variables in cfa.y
extern int yyparse(void);
extern int yydebug;
extern LinkageSpec::Type linkage;
extern TypedefTable typedefTable;
extern DeclarationNode *theTree;

Parser *Parser::theParser = 0;

Parser::Parser(): parseTree( 0 ), parseStatus( 1 ) {}

Parser::~Parser() {
	delete parseTree;
}

Parser &Parser::get_parser() {
	if ( theParser == 0 ) {
		theParser = new Parser;
	} // if
	return *theParser;
}

void Parser::parse( FILE *input ) {
	extern FILE *yyin;
	yyin = input;
	extern int yylineno;
	yylineno = 1;
	typedefTable.enterScope();
	parseStatus = yyparse();
	parseTree = theTree;
}

void Parser::set_debug( bool debug ) {
	yydebug = debug;
}

void Parser::set_linkage( LinkageSpec::Type linkage ) {
	::linkage = linkage;
}

void Parser::freeTree() {
	delete parseTree;
	parseTree = 0;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
