//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ChooseMutator.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 15:33:11 2015
// Update Count     : 3
//

#ifndef CHOOSE_MUTATOR_H
#define CHOOSE_MUTATOR_H

#include "SynTree/Mutator.h"

#include "utility.h"

namespace ControlStruct {
	/// transform choose statements into switch statements
	class ChooseMutator : public Mutator {
	  public:
		ChooseMutator() : insideChoose( false ) {}

		virtual Statement *mutate( ChooseStmt * );
		virtual Statement *mutate( SwitchStmt * );
		virtual Statement *mutate( FallthruStmt * );
		virtual Statement *mutate( CaseStmt * );
	  private:
		bool insideChoose;
	};
} // namespace ControlStruct

#endif // CHOOSE_MUTATOR_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
