#include <fstream>
#include <kernel>
#include <stdlib>
#include <thread>
#include <time>

#ifndef PREEMPTION_RATE
#define PREEMPTION_RATE 10`ms
#endif

Duration default_preemption() {
	return PREEMPTION_RATE;
}

#ifdef LONG_TEST
static const unsigned long N = 600_000ul;
#else
static const unsigned long N = 1_000ul;
#endif

coroutine Coroutine {};

void main(Coroutine& this) {
	while(true) {
		sout | "Coroutine 1" | endl;
		yield();
		sout | "Coroutine 2" | endl;
		suspend();
	}
}


int main(int argc, char* argv[]) {
	Coroutine c;
	for(int i = 0; i < N; i++) {
		sout | "Thread 1" | endl;
		resume(c);
		sout | "Thread 2" | endl;
		yield();
	}
}
