#pragma once

#ifdef __CFORALL__
extern "C" {
#endif
	#include <unistd.h>					// sysconf
	#include <sys/times.h>					// times
	#include <time.h>
#ifdef __CFORALL__
}
#endif


static inline unsigned long long int Time() {
    struct timespec ts;
    clock_gettime(
#if defined( __linux__ )
	 CLOCK_THREAD_CPUTIME_ID,
#elif defined( __freebsd__ )
	 CLOCK_PROF,
#elif defined( __solaris__ )
	 CLOCK_HIGHRES,
#else
    #error uC++ : internal error, unsupported architecture
#endif
	 &ts );
    return 1000000000LL * ts.tv_sec + ts.tv_nsec;
} // Time

#ifndef N
#define N 10000000
#endif

unsigned int default_preemption() {
	return 0;
}