//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// TrackLoc.h -- Track CodeLocation information in a translation unit's declarations.
//
// Author           : Andrew Beach
// Created On       : Tues May 2 15:40:00 2017
// Last Modified By : Andrew Beach
// Last Modified On : Wed May 3 14:42:00 2017
// Update Count     : 0
//

#ifndef TRACKLOC_H
#define TRACKLOC_H

#include "SynTree/SynTree.h"

namespace CodeTools {

	/// Fill in an approximate CodeLocation for each syntax node.
	// printLevel: how much printing while filling in the node locations.
	// 0 - No Printing, 1 - Print Location, 2 - Print Node Type and Location
	void fillLocations( std::list< Declaration * > &translationUnit,
			unsigned int printLevel = 0 );

}  // namespace CodeTools

#endif // TRACKLOC_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
