//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// tuplePolymorphism.c --
//
// Author           : Rob Schluntz
// Created On       : Fri Dec 16 10:25:35 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Fri Dec 21 14:42:48 2016
// Update Count     : 2
//

forall(otype T) T * malloc();

forall(otype T, ttype Params | sized(T) | { void ?{}(T *, Params); })
T * new(Params p) {
	return ((T*)malloc()){ p };
}

struct array {
	int * data;
	int size;
};

// xxx - eventually this will be collapsed...x
void ?{}(array * a) {
	a->size = 0;
	a->data = 0;
	printf("called ?{} with no a\n");
}

void ?{}(array * a, int a0) {
	a->size = 1;
	a->data = (int*)malloc(sizeof(int)*a->size);
	a->data[0] = a0;
	printf("called ?{} with a: %d\n", a0);
}

void ?{}(array * a, int a0, int a1) {
	a->size = 2;
	a->data = (int*)malloc(sizeof(int)*a->size);
	a->data[0] = a0;
	a->data[1] = a1;
	printf("called ?{} with a: %d %d\n", a0, a1);
}

void ?{}(array * a, int a0, int a1, int a2) {
	a->size = 3;
	a->data = (int*)malloc(sizeof(int)*a->size);
	a->data[0] = a0;
	a->data[1] = a1;
	a->data[2] = a2;
	printf("called ?{} with a: %d %d %d\n", a0, a1, a2);
}

void ?{}(array * a, int a0, int a1, int a2, int a3) {
	a->size = 4;
	a->data = (int*)malloc(sizeof(int)*a->size);
	a->data[0] = a0;
	a->data[1] = a1;
	a->data[2] = a2;
	a->data[3] = a3;
	printf("called ?{} with a: %d %d %d %d\n", a0, a1, a2, a3);
}

void print(array * x) {
	printf("array = { ");
	for (int i = 0; i < x->size; ++i) {
		printf("%d, ", x->data[i]);
	}
	printf("}\n");
}

int main() {
	// xxx - these two don't work just yet
	// array * x0 = new();
	// print(x0);

	// array * x1 = new(999);
	// print(x1);

	array * x2 = new(123, 456);
	print(x2);

	array * x3 = new(100, 200, 300);
	print(x3);

	array * x4 = new(10, 2, 3, 4);
	print(x4);
}

// Local Variables: //
// tab-width: 4 //
// End: //

