
#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>

#include "libhdr.h"
#include "invoke.h"

struct machine_context_t {
	void *SP;
	void *FP;
	void *PC;
};

extern void coInvokeStub( void );

// magically invoke the "main" of the most derived class
// Called from the kernel when starting a coroutine or task so must switch back to user mode.
void __invokeCoroutine__F_P9scoVtablePv__1(struct coVtable *vtable, void* vthis)
{
      LIB_DEBUG_PRINTF("Invoke : Received %p (v %p)\n", vthis, vtable);

      struct coroutine* cor = vtable->this_coroutine(vthis);

      cor->state = Active;

      vtable->main(vthis);
}

void __startCoroutine__A0_1_0___this_coroutine__PFP10scoroutine_Pd0___co_main__PF_Pd0___vtable__PFP9scoVtable_Pd0__F_Pd0PF_P9scoVtablePv___1(
      struct coroutine *(*this_coroutine)(void * ),
      void (*co_main)(void *),
      struct coVtable *(*get_vtable)(void *),
      void *vthis,
      void (*invoke)(struct coVtable *, void *)
) {
      LIB_DEBUG_PRINTF("StartCoroutine : Passing in %p (v %p) to %p\n", vthis, vtable, invoke);

      struct coVtable * vtable = get_vtable( vthis );
      struct coroutine* this = this_coroutine( vthis );
      struct coStack_t* stack = &this->stack;

#if defined( __i386__ )

	struct FakeStack {
	    void *fixedRegisters[3];		  	// fixed registers ebx, edi, esi (popped on 1st uSwitch, values unimportant)
	    void *rturn;				      // where to go on return from uSwitch
	    void *dummyReturn;				// fake return compiler would have pushed on call to uInvoke
	    void *argument[2];				// for 16-byte ABI, 16-byte alignment starts here
	    void *padding[2];				// padding to force 16-byte alignment, as "base" is 16-byte aligned
	};

	((struct machine_context_t *)stack->context)->SP = (char *)stack->base - sizeof( struct FakeStack );
	((struct machine_context_t *)stack->context)->FP = NULL;		// terminate stack with NULL fp

	((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->dummyReturn = NULL;
	((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->argument[0] = vtable; // argument to invoke
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->argument[1] = vthis;  // argument to invoke
	((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->rturn = invoke;

#elif defined( __x86_64__ )

      struct FakeStack {
            void *fixedRegisters[5];			// fixed registers rbx, r12, r13, r14, r15
            void *rturn;					// where to go on return from uSwitch
            void *dummyReturn;				// NULL return address to provide proper alignment
      };

      ((struct machine_context_t *)stack->context)->SP = (char *)stack->base - sizeof( struct FakeStack );
      ((struct machine_context_t *)stack->context)->FP = NULL;		// terminate stack with NULL fp

      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->dummyReturn = NULL;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->rturn = coInvokeStub;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->fixedRegisters[0] = vtable;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->fixedRegisters[1] = vthis;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->fixedRegisters[2] = invoke;
#else
      #error Only __i386__ and __x86_64__ is supported for threads in cfa
#endif
}
