#include <iostream>
#include <strstream>

#include "LabelGenerator.h"

namespace ControlStruct {
    LabelGenerator *LabelGenerator::labelGenerator = 0;

    LabelGenerator *LabelGenerator::getGenerator() {
	if ( LabelGenerator::labelGenerator == 0 )
	    LabelGenerator::labelGenerator = new LabelGenerator();

	return labelGenerator;
    }

    Label LabelGenerator::newLabel() {
	std::ostrstream os;
	os << "__L" << current++ << "__";// << std::ends;
	os.freeze( false );
	std::string ret = std::string (os.str(), os.pcount());
	return Label( ret );
    }
} // namespace ControlStruct
