#include "SynTree/Mutator.h"
#include "SynTree/Statement.h"
#include "ForExprMutator.h"

namespace ControlStruct {
    Statement *ForExprMutator::mutate( ForStmt *forStmt ) {
	DeclStmt *decl;
	if (( decl = dynamic_cast< DeclStmt * > ( forStmt->get_initialization() )) != 0 ) {
	    // create compound statement, move declaration outside, leave _for_ as-is
	    CompoundStmt *block = new CompoundStmt( std::list< Label >() );
	    std::list<Statement *> &stmts = block->get_kids();

	    stmts.push_back( decl );
	    forStmt->set_initialization( 0 );
	    stmts.push_back( forStmt );

	    return block;
	} // if
	// ForStmt still needs to be fixed
	else
	    return forStmt;
    }
} // namespace ControlStruct
