#ifndef CASERNG_MUTATOR_H
#define CASERNG_MUTATOR_H

#include <list>

#include "SynTree/Mutator.h"

namespace ControlStruct {
    class CaseRangeMutator : public Mutator {
      public:
	CaseRangeMutator() {}

	virtual Statement *mutate( ChooseStmt * );
	virtual Statement *mutate( SwitchStmt * );
	virtual Statement *mutate( FallthruStmt * );
	virtual Statement *mutate( CaseStmt * );
      private:
	void fillRange( Expression *lo, Expression *hi );

	Expression *currentCondition;
	std::list< Expression * > newCaseLabels;
    };

} // namespace ControlStruct

#endif // CASERNG_MUTATOR_H

/*
  Local Variables:
  mode: c++
  End:
*/
