//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// quad.c --
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Dec 11 23:26:58 2018
// Update Count     : 9
//

#include <fstream.hfa>

forall( otype T | { T ?*?( T, T ); } )
T square( T t ) {
	return t * t;
}

forall( otype U | { U square( U ); } )
U quad( U u ) {
	return square( square( u ) );
}

int main() {
	int N = 2;
	sout | "result of quad of" | N | "is" | quad( N );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa quad.c" //
// End: //
