#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

void sig_handler(int signo)
{
	fprintf(stderr, "received %d\n", signo);
	exit(0);
}

void sig(int signo) {
	if (signal(signo, sig_handler) == SIG_ERR)
	{
		fprintf(stderr,"Error\n");
		exit(1);
	}
}

int main(void)
{
	printf("Starting...\n");
	sig(SIGHUP);
	sig(SIGINT);
	sig(SIGQUIT);
	sig(SIGILL);
	sig(SIGABRT);
	sig(SIGFPE);
	sig(SIGSEGV);
	sig(SIGPIPE);
	sig(SIGALRM);
	sig(SIGTERM);
	sig(SIGUSR1);
	sig(SIGUSR2);
	sig(SIGCHLD);
	sig(SIGCONT);
	sig(SIGTSTP);
	sig(SIGTTIN);
	sig(SIGTTOU);
	while(1);
	return 0;
}
