//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Stmt.cpp --
//
// Author           : Aaron B. Moss
// Created On       : Wed May  8 13:00:00 2019
// Last Modified By : Andrew Beach
// Last Modified On : Wed May 15 15:53:00 2019
// Update Count     : 2
//

#include "Stmt.hpp"

#include "DeclReplacer.hpp"

namespace ast {

// --- CompoundStmt
CompoundStmt::CompoundStmt( const CompoundStmt& o ) : Stmt(o), kids(o.kids) {
#   warning unimplemented
	assert(!"implemented");
}

// --- BranchStmt
BranchStmt::BranchStmt( const CodeLocation& loc, Kind kind, Label target, std::vector<Label>&& labels )
: Stmt(loc, std::move(labels)), originalTarget(target), target(target), kind(kind) {
	// Make sure a syntax error hasn't slipped through.
	assert( Goto != kind || !target.empty() );
}

const char * BranchStmt::kindNames[] = {
    "Goto", "Break", "Continue", "FallThrough", "FallThroughDefault"
};

}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
