//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// GenericSubstitution.cpp --
//
// Author           : Aaron B. Moss
// Created On       : Wed May 22 14:15:00 2019
// Last Modified By : Aaron B. Moss
// Created On       : Wed May 22 14:15:00 2019
// Update Count     : 1
//

#include "GenericSubstitution.hpp"

#include <cassert>
#include <utility>               // for move

#include "Decl.hpp"
#include "Node.hpp"              // for maybe_accept
#include "Pass.hpp"
#include "Type.hpp"
#include "TypeSubstitution.cpp"

namespace ast {

namespace {
	struct GenericSubstitutionBuilder : public WithShortCircuiting {
		TypeSubstitution sub;

		void previsit( const Type * ty ) {
			assertf( false, "Attempted generic substitution for non-aggregate type: %s", 
				toString( ty ).c_str() );
		}

		void previsit( const ReferenceType * ) {
			// do nothing; allows substitution from base type
		}

		void previsit( const ReferenceToType * ty ) {
			// build substitution from base parameters
			const AggregateDecl * aggr = ty->aggr();
			sub = TypeSubstitution{ aggr->params.begin(), aggr->params.end(), ty->params.begin() };
			visit_children = false;
		}
	};
}

TypeSubstitution genericSubsitution( const Type * ty ) {
	Pass<GenericSubstitutionBuilder> builder;
	maybe_accept( ty, builder );
	return std::move(builder.pass.sub);
}

}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //