#pragma once
#include <utility>

template<typename R, typename S> struct pair {
	R first;
	S second;

	pair() = default;
	pair( R&& x, S&& y ) : first( std::move(x) ), second( std::move(y) ) {}

	bool operator< (const pair<R, S>& o) const {
		return first < o.first || ( first == o.first && second < o.second );
	}

	bool operator<= (const pair<R, S>& o) const {
		return first < o.first || ( first == o.first && second <= o.second );
	}

	bool operator== (const pair<R, S>& o) const { return first == o.first && second == o.second; }

	bool operator!= (const pair<R, S>& o) const { return first != o.first || second != o.second; }

	bool operator> (const pair<R, S>& o) const {
		return first > o.first || ( first == o.first && second > o.second );
	}

	bool operator>= (const pair<R, S>& o) const {
		return first > o.first || ( first == o.first && second >= o.second );
	}
};
