//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FlattenTuple.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 11:28:15 2015
// Update Count     : 3
//

#ifndef _FLATTEN_TUPLE_H_
#define _FLATTEN_TUPLE_H_

#include "SynTree/Mutator.h"
#include "SynTree/Visitor.h"

#include "SynTree/Expression.h"

namespace Tuples {
	class FlattenTuple : public Mutator {
		typedef Mutator Parent;
	  public:
		FlattenTuple();
		~FlattenTuple();

		virtual Expression *mutate( TupleExpr *tupleExpr );
	  private:
		class CollectArgs : public Visitor {
		  public:
			virtual void visit( UntypedExpr * );
			virtual void visit( NameExpr * );
			virtual void visit( CastExpr *);
			virtual void visit( AddressExpr * );
			virtual void visit( UntypedMemberExpr * );
			virtual void visit( MemberExpr * );
			virtual void visit( VariableExpr * );
			virtual void visit( ConstantExpr * ); 
			virtual void visit( SizeofExpr * );
			virtual void visit( AlignofExpr * );
			virtual void visit( UntypedOffsetofExpr * );
			virtual void visit( OffsetofExpr * );
			virtual void visit( OffsetPackExpr * );
			virtual void visit( AttrExpr * );
			virtual void visit( LogicalExpr * );
			virtual void visit( ConditionalExpr * );
			virtual void visit( CommaExpr * );
			virtual void visit( TypeExpr * );
			virtual void visit( UntypedValofExpr * );

			virtual void visit( TupleExpr *tupleExpr );

			std::list< Expression *> &get_args() { return currentArgs; }
		  private:
			std::list< Expression * > currentArgs;
		};

	};
} // namespace Tuples

#endif // _FLATTEN_TUPLE_H_

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
