#pragma once

#include <stddef.h>
#include <stdint.h>

#include "tools.h"

#if DEBUG
	static const void* CANARY_VALUE = (void*)0xCAFEBABACAFEBABA;
#endif

struct gcpointer_t;
struct gc_object_header;

struct gc_object_header
{
	#if DEBUG
		void* canary_start;
	#endif

	size_t		size;
	gcpointer_t* 	root_chain;
	gcpointer_t*	type_chain;
	gc_object_header*	forward;
	bool			is_forwarded;

	#if DEBUG
		void* canary_end;
	#endif
};

gc_object_header* gc_object_header_placement_ctor(void* address, size_t size);
gc_object_header* gc_object_header_placement_copy_ctor(void* address, gc_object_header* other);
