//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CodeLocationTools.hpp -- Additional tools for code locations.
//
// Author           : Andrew Beach
// Created On       : Fri Dec  4 15:35:00 2020
// Last Modified By : Andrew Beach
// Last Modified On : Fri Dec  4 16:18:00 2020
// Update Count     : 0
//

#pragma once

// Additional tools for code locations.

namespace ast {
	struct TranslationUnit;
}

/// Search the translation unit for unset code locations and print information
/// on them. Abort if any unset code locations are found.
void checkAllCodeLocations( ast::TranslationUnit const & unit );

// Assign a nearby code-location to any unset code locations in the forest.
void forceFillCodeLocations( ast::TranslationUnit & unit );
