//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Initializer.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Aug 12 14:05:25 2015
// Update Count     : 14
//

#include "Initializer.h"
#include "Expression.h"
#include "utility.h"

Initializer::Initializer() {}

Initializer::~Initializer() {}

std::string Initializer::designator_name( Expression *des ) {
	if ( NameExpr *n = dynamic_cast<NameExpr *>(des) )
		return n->get_name();
	else
		throw 0;
}

void Initializer::print( std::ostream &os, int indent ) {}

SingleInit::SingleInit( Expression *v, std::list< Expression *> &_designators ) : value ( v ), designators( _designators ) { 
}

SingleInit::SingleInit( const SingleInit &other ) : value ( other.value ) {
	cloneAll(other.designators, designators );
}

SingleInit::~SingleInit() {}

SingleInit *SingleInit::clone() const { return new SingleInit( *this); }

void SingleInit::print( std::ostream &os, int indent ) {
	os << std::endl << std::string(indent, ' ' ) << "Simple Initializer: " << std::endl;
	value->print( os, indent+4 );

	if ( ! designators.empty() ) {
		os << std::endl << std::string(indent + 2, ' ' ) << "designated by: "   << std::endl;
		for ( std::list < Expression * >::iterator i = designators.begin(); i != designators.end(); i++ ) {
			( *i )->print(os, indent + 4 );
		}
	} // if
}

ListInit::ListInit( std::list<Initializer*> &_initializers, std::list<Expression *> &_designators )
	: initializers( _initializers ), designators( _designators ) {
}

ListInit::~ListInit() {}

ListInit *ListInit::clone() const {
	return new ListInit( *this );
}

void ListInit::print( std::ostream &os, int indent ) {
	os << std::endl << std::string(indent, ' ') << "Compound initializer:  "; 
	if ( ! designators.empty() ) {
		os << std::string(indent + 2, ' ' ) << "designated by: [";
		for ( std::list < Expression * >::iterator i = designators.begin();
			  i != designators.end(); i++ ) {
			( *i )->print(os, indent + 4 ); 
		} // for
	
		os << std::string(indent + 2, ' ' ) << "]";
	} // if

	for ( std::list<Initializer *>::iterator i = initializers.begin(); i != initializers.end(); i++ ) 
		(*i)->print( os, indent + 2 );
}
// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
