//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Constant.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jun 21 16:44:48 2017
// Update Count     : 27
//

#include <iostream>
#include <list>
#include <string>

#include "Constant.h"
#include "Type.h"

Constant::Constant( Type * type, std::string rep, unsigned long long val ) : type( type ), rep( rep ), val( val ) {}
Constant::Constant( Type * type, std::string rep, double val ) : type( type ), rep( rep ), val( val ) {}

Constant::Constant( const Constant &other ) : rep( other.rep ), val( other.val ) {
	type = other.type->clone();
}

Constant::~Constant() { delete type; }

Constant Constant::from_int( int i ) {
	return Constant( new BasicType( Type::Qualifiers(), BasicType::SignedInt ), std::to_string( i ), (unsigned long long int)i );
}

Constant Constant::from_ulong( unsigned long i ) {
	return Constant( new BasicType( Type::Qualifiers(), BasicType::LongUnsignedInt ), std::to_string( i ), (unsigned long long int)i );
}

Constant Constant::from_double( double d ) {
	return Constant( new BasicType( Type::Qualifiers(), BasicType::Double ), std::to_string( d ), d );
}

void Constant::print( std::ostream &os ) const {
	os << "(" << rep << " " << val.ival;
	if ( type ) {
		os << ": ";
		type->print( os );
	} // if
  os << ")";
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
