//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LinkageSpec.cc --
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:22:09 2015
// Last Modified By : Andrew Beach
// Last Modified On : Fri Jul  7 11:11:00 2017
// Update Count     : 25
//

#include <memory>
#include <string>
#include <cassert>
using namespace std;

#include "LinkageSpec.h"
#include "Common/SemanticError.h"

namespace LinkageSpec {

Spec linkageCheck( CodeLocation location, const string * spec ) {
	assert( spec );
	unique_ptr<const string> guard( spec );	// allocated by lexer
	if ( *spec == "\"Cforall\"" ) {
		return Cforall;
	} else if ( *spec == "\"C\"" ) {
		return C;
	} else if ( *spec == "\"BuiltinC\"" ) {
		return BuiltinC;
	} else {
		throw SemanticError( location, "Invalid linkage specifier " + *spec );
	} // if
}

Spec linkageUpdate( CodeLocation location, Spec old_spec, const string * cmd ) {
	assert( cmd );
	unique_ptr<const string> guard( cmd ); // allocated by lexer
	if ( *cmd == "\"Cforall\"" ) {
		old_spec.is_mangled = true;
		return old_spec;
	} else if ( *cmd == "\"C\"" ) {
		old_spec.is_mangled = false;
		return old_spec;
	} else {
		throw SemanticError( location, "Invalid linkage specifier " + *cmd );
	} // if
}

std::string linkageName( Spec linkage ) {
    switch ( linkage ) {
    case Intrinsic:
        return "intrinsic";
    case C:
        return "C";
    case Cforall:
        return "Cforall";
    case AutoGen:
        return "autogenerated cfa";
    case Compiler:
        return "compiler built-in";
    case BuiltinCFA:
        return "cfa built-in";
    case BuiltinC:
        return "c built-in";
    default:
        return "<unnamed linkage spec>";
    }
}

} // LinkageSpec

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
