#ifndef SYMTAB_INDEXER_H
#define SYMTAB_INDEXER_H

#include <list>
#include <string>
#include <map>

#include "SynTree/Visitor.h"
#include "IdTable.h"
#include "AggregateTable.h"
#include "TypeTable.h"

namespace SymTab {
    class Indexer : public Visitor {
      public:
	Indexer( bool useDebug = false );
	virtual ~Indexer();

	//using Visitor::visit;
	virtual void visit( ObjectDecl *objectDecl );
	virtual void visit( FunctionDecl *functionDecl );
	virtual void visit( TypeDecl *typeDecl );
	virtual void visit( TypedefDecl *typeDecl );
	virtual void visit( StructDecl *aggregateDecl );
	virtual void visit( UnionDecl *aggregateDecl );
	virtual void visit( EnumDecl *aggregateDecl );
	virtual void visit( ContextDecl *aggregateDecl );

	virtual void visit( CompoundStmt *compoundStmt );

	virtual void visit( ContextInstType *contextInst );
	virtual void visit( StructInstType *contextInst );
	virtual void visit( UnionInstType *contextInst );

	virtual void visit( ForStmt *forStmt );

	// when using an indexer manually (e.g., within a mutator traversal), it is necessary to tell the indexer
	// explicitly when scopes begin and end
	void enterScope();
	void leaveScope();

	void lookupId( const std::string &id, std::list< DeclarationWithType* >& ) const;
	DeclarationWithType* lookupId( const std::string &id) const;
	NamedTypeDecl *lookupType( const std::string &id ) const;
	StructDecl *lookupStruct( const std::string &id ) const;
	EnumDecl *lookupEnum( const std::string &id ) const;
	UnionDecl *lookupUnion( const std::string &id ) const;
	ContextDecl *lookupContext( const std::string &id ) const;
  
	void print( std::ostream &os, int indent = 0 ) const;
      private:
	IdTable idTable;
	TypeTable typeTable;
	StructTable structTable;
	EnumTable enumTable;
	UnionTable unionTable;
	ContextTable contextTable;
  
	bool doDebug;					// display debugging trace
    };
} // namespace SymTab

#endif // SYMTAB_INDEXER_H
