#pragma once

// #include <stddef.h>
// #include <stdint.h>
//
// static const size_t POOL_SIZE_EXP = 24;
// static const size_t POOL_SIZE_BYTES = 0x1 << POOL_SIZE_EXP;
// static const size_t POOL_PTR_MASK = ~(POOL_SIZE_BYTES - 1);
//
// static const size_t CARDS_SIZE_EXP = 12;
// static const size_t CARDS_SIZE_BYTES = 0x1 << CARDS_SIZE_EXP;
// static const size_t CARDS_OFFSET_MASK = (~(CARDS_SIZE_BYTES - 1)) & (POOL_SIZE_BYTES - 1);
// static const size_t CARDS_COUNT = POOL_SIZE_BYTES / CARDS_SIZE_BYTES;
//
// static const size_t OBJECT_ALLIGNMENT = sizeof(size_t);
// static const size_t OBJECT_PTR_MASK = ~(OBJECT_ALLIGNMENT - 1);


#define POOL_SIZE_EXP 24
#define POOL_SIZE_BYTES 0x1 << POOL_SIZE_EXP
#define POOL_PTR_MASK ~(POOL_SIZE_BYTES - 1)

#define CARDS_SIZE_EXP 12
#define CARDS_SIZE_BYTES 0x1 << CARDS_SIZE_EXP
#define CARDS_OFFSET_MASK (~(CARDS_SIZE_BYTES - 1)) & (POOL_SIZE_BYTES - 1)
#define CARDS_COUNT POOL_SIZE_BYTES / CARDS_SIZE_BYTES

#define OBJECT_ALLIGNMENT sizeof(size_t)
#define OBJECT_PTR_MASK ~(OBJECT_ALLIGNMENT - 1)
