//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AggregateDecl.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 23:56:39 2015
// Last Modified By : Andrew Beach
// Last Modified On : Fri Aug  4 14:22:00 2017
// Update Count     : 22
//

#include <list>                  // for list
#include <ostream>               // for operator<<, basic_ostream, ostream
#include <string>                // for operator<<, string, char_traits

#include "Attribute.h"           // for Attribute
#include "Common/utility.h"      // for printAll, cloneAll, deleteAll
#include "Declaration.h"         // for AggregateDecl, TypeDecl, Declaration
#include "Parser/LinkageSpec.h"  // for Spec, linkageName, Cforall
#include "Type.h"                // for Type, Type::StorageClasses


AggregateDecl::AggregateDecl( const std::string &name, const std::list< Attribute * > & attributes, LinkageSpec::Spec linkage ) : Parent( name, Type::StorageClasses(), linkage ), body( false ), attributes( attributes ) {
}

AggregateDecl::AggregateDecl( const AggregateDecl &other ) : Parent( other ) {
	cloneAll( other.members, members );
	cloneAll( other.parameters, parameters );
	cloneAll( other.attributes, attributes );
	body = other.body;
}

AggregateDecl::~AggregateDecl() {
	deleteAll( attributes );
	deleteAll( parameters );
	deleteAll( members );
}

void AggregateDecl::print( std::ostream &os, int indent ) const {
	using std::string;
	using std::endl;

	os << typeString() << " " << get_name() << ":";
	if ( get_linkage() != LinkageSpec::Cforall ) {
		os << " " << LinkageSpec::linkageName( get_linkage() );
	} // if
	os << " with body " << has_body() << endl;

	if ( ! parameters.empty() ) {
		os << endl << string( indent+2, ' ' ) << "with parameters" << endl;
		printAll( parameters, os, indent+4 );
	} // if
	if ( ! members.empty() ) {
		os << endl << string( indent+2, ' ' ) << "with members" << endl;
		printAll( members, os, indent+4 );
	} // if
	if ( ! attributes.empty() ) {
		os << endl << string( indent+2, ' ' ) << "with attributes" << endl;
		printAll( attributes, os, indent+4 );
	} // if
}

void AggregateDecl::printShort( std::ostream &os, int indent ) const {
	using std::string;
	using std::endl;

	os << typeString() << " " << get_name();
	os << string( indent+2, ' ' ) << "with body " << has_body() << endl;

	if ( ! parameters.empty() ) {
		os << endl << string( indent+2, ' ' ) << "with parameters" << endl;
		printAll( parameters, os, indent+4 );
	} // if
}

std::string StructDecl::typeString() const { return "struct"; }

std::string UnionDecl::typeString() const { return "union"; }

std::string EnumDecl::typeString() const { return "enum"; }

std::string TraitDecl::typeString() const { return "trait"; }

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
