//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// algorithm.c -- 
//
// Author           : Peter A. Buhr
// Created On       : Thu Jan 28 17:10:29 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jan 29 15:49:59 2016
// Update Count     : 29
//

#include "algorithm"

forall( type T | { int ?<?( T, T ); } )
T min( const T t1, const T t2 ) {
	return t1 < t2 ? t1 : t2;
} // min

forall( type T | { int ?>?( T, T ); } )
T max( const T t1, const T t2 ) {
	return t1 > t2 ? t1 : t2;
} // max


extern "C" {
#include <stdlib.h>										// abs, labs, llabs
#include <math.h>										// fabsf, fabs, fabsl
#include <complex.h>									// cabsf, cabs, cabsl
} // extern

char abs( char v ) { return abs( (int)v ); }
long int abs( long int v ) { return labs( v ); }
long long int abs( long long int v ) { return llabs( v ); }
float abs( float v ) { return fabsf( v ); }
double abs( double v ) { return fabs( v ); }
long double abs( long double v ) { return fabsl( v ); }
float _Complex abs( float _Complex v ) { return cabsf( v ); }
double _Complex abs( double _Complex v ) { return cabs( v ); }
long double _Complex abs( long double _Complex v ) { return cabsl( v ); }


// Local Variables: //
// tab-width: 4 //
// End: //
