//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// identity.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jan 26 17:11:58 2016
// Update Count     : 8
//

#include <fstream>

forall( type T )
T identity( T t ) {
	return t;
}

int main() {
	ofstream *sout = ofstream_stdout();
	sout | "char\t\t\t"					| identity( 'z' ) | endl;
	sout | "signed int\t\t"				| identity( 4 ) | endl;
	sout | "unsigned int\t\t"			| identity( 4u ) | endl;
	sout | "signed long int\t\t" 		| identity( 4l ) | endl;
	sout | "unsigned long int\t" 		| identity( 4ul ) | endl;
	sout | "signed long long int\t"		| identity( 4ll ) | endl;
	sout | "unsigned long long int\t"	| identity( 4ull ) | endl;
	sout | "float\t\t\t" 				| identity( 4.0f ) | endl;
	sout | "double\t\t\t"				| identity( 4.0 ) | endl;
	sout | "long double\t\t"			| identity( 4.0l ) | endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa identity.c" //
// End: //
