//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// InitExpander.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:35:33 2015
// Update Count     : 2
//

#ifndef _INIT_EXPANDER_H_
#define _INIT_EXPANDER_H_

#include <string>

#include "Common/utility.h"
#include "SynTree/Mutator.h"
#include "SymTab/Indexer.h"

#include "SynTree/Statement.h"
#include "SynTree/Declaration.h"
#include "SynTree/Type.h"

namespace InitTweak {
	class InitExpander : public Mutator {
		typedef Mutator Parent;
	  public:
		InitExpander();
		~InitExpander();

		virtual ObjectDecl *mutate( ObjectDecl * );

		// indexer runs
		virtual FunctionDecl   *mutate( FunctionDecl *functionDecl ) {
			functionDecl->set_functionType( maybeMutate( functionDecl->get_functionType(), *this ) );
			mutateAll( functionDecl->get_oldDecls(), *this );
			functionDecl->set_statements( maybeMutate( functionDecl->get_statements(), *this ) );

			index.visit( functionDecl );
			return functionDecl;
		}

		virtual TypeDecl *mutate( TypeDecl *typeDecl )
			{ index.visit( typeDecl ); return typeDecl; }
		virtual TypedefDecl *mutate( TypedefDecl *typeDecl )
			{ index.visit( typeDecl ); return typeDecl; }
		virtual StructDecl *mutate( StructDecl *aggregateDecl )
			{ index.visit( aggregateDecl ); return aggregateDecl; }
		virtual UnionDecl *mutate( UnionDecl *aggregateDecl )
			{ index.visit( aggregateDecl ); return aggregateDecl; }
		virtual EnumDecl *mutate( EnumDecl *aggregateDecl )
			{ index.visit( aggregateDecl ); return aggregateDecl; }

		virtual Type *mutate( StructInstType *aggrInst )
			{ index.visit( aggrInst ); return aggrInst; }
		virtual Type *mutate( UnionInstType *aggrInst )
			{ index.visit( aggrInst ); return aggrInst; }
	  private:
		SymTab::Indexer index;
	};  // class InitExpander
} // namespace InitTweak

#endif // _INIT_EXPANDER_H_

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
