//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// DeclarationHoister.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:33:20 2015
// Update Count     : 2
//

#include <list>
#include <cassert>
#include <iostream>
#include <iterator>
#include <algorithm>

#include "Common/utility.h"

#include "SynTree/Statement.h"
#include "SynTree/Expression.h"
#include "SynTree/Declaration.h"

#include "DeclarationHoister.h"

namespace InitTweak {
	CompoundStmt* DeclarationHoister::mutate( CompoundStmt *compoundStmt ) {
		typedef std::list<Statement *>::iterator stmt_it;
		// 1. collect Declaration Statements  in this scope
		std::list<Statement *> &kids = compoundStmt->get_kids();
		std::list<Statement *>::iterator result = kids.begin();
		std::list< stmt_it > decls;

		while ( result !=  kids.end() ) {
			result = std::find_if (result, kids.end(), cast_ptr< Statement, DeclStmt > );

			if ( result != kids.end() ) {
				decls.push_back( result );
				std::advance( result, 1 );
			} // if
		} // while

		for ( std::list< stmt_it >::reverse_iterator i = decls.rbegin(); i!= decls.rend(); i++ ) {
			kids.push_front( **i );
			kids.erase( *i );
		} // for

		return compoundStmt;
	}
} // namespace InitTweak

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
