//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// square.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jan 26 17:14:16 2016
// Update Count     : 25
//

#include <fstream>

forall( type T | { T ?*?( T, T ); } )
T square( T t ) {
	return t * t;
} // square

int main() {
#if 0
	ofstream *sout = ofstream_stdout();
	sout | "result of squaring 9 is " | endl;

	// char does not have multiplication.
	char ?*?( char a1, char a2 ) {
		return (char)((int)a1 * (int)a2);
	} // ?*?
	char c = 9;
	sout | "char\t\t\t" | square( c ) | endl;

	sout | square( s ) | endl;
#endif
	short s = 9;
	square( s );
#if 0
	signed int i = 9;
	sout | "signed int\t\t" | square( i ) | endl;

	unsigned int ui = 9;
	sout | "unsigned int\t\t" | square( ui ) | endl;

	long int li = 9;
	sout | "signed long int\t\t" | square( li ) | endl;

	unsigned long int uli = 9;
	sout | "unsigned long int\t" | square( uli ) | endl;

	signed long long int lli = 9;
	sout | "signed long long int\t" | square( lli ) | endl;

	unsigned long long int ulli = 9;
	sout | "unsigned long long int\t" | square( ulli ) | endl;

	float f = 9.0;
	sout | "float\t\t\t" | square( f ) | endl;

	double d = 9.0;
	sout | "double\t\t\t" | square( d ) | endl;

	long double ld = 9.0;
	sout | "long double\t\t" | square( ld ) | endl;
#endif
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa square.c" //
// End: //
