//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// abs.c -- 
//
// Author           : Peter A. Buhr
// Created On       : Thu Jan 28 18:26:16 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jan 29 15:44:41 2016
// Update Count     : 20
//

extern "C" {
#include <complex.h>
} // extern
#include <fstream>
#include <algorithm>

int main( void ) {
	ofstream *sout = ofstream_stdout();

	char ch = -65;
	sout | "char\t\t\t"					| -65    | "\tabs " | abs( ch ) | endl;
	sout | "signed int\t\t"				| -65    | "\tabs " | abs( -65 ) | endl;
	sout | "signed long int\t\t" 		| -65l   | "\tabs " | abs( -65l ) | endl;
	sout | "signed long long int\t"		| -65ll  | "\tabs " | abs( -65ll ) | endl;
	sout | "float\t\t\t" 				| -65.0f | "\tabs " | abs( -65.0f ) | endl;
	sout | "double\t\t\t"				| -65.0  | "\tabs " | abs( -65.0 ) | endl;
	sout | "long double\t\t"			| -65.0l | "\tabs " | abs( -65.0l ) | endl;
	double _Complex c = -65.0+2.0 * I;
	sout | "double _Complex\t\t"		| c | "\tabs " | abs( c ) | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa abs.c" //
// End: //
