//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FunctionChecker.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 12:00:57 2015
// Update Count     : 2
//

#ifndef _TUPLE_FUNCHK_H_
#define _TUPLE_FUNCHK_H_

#include <string>
#include <list>
#include <iostream>

#include "Common/UniqueName.h"

#include "SynTree/SynTree.h"
#include "SynTree/Mutator.h"

#include "SynTree/Type.h"
#include "SynTree/Declaration.h"
#include "SynTree/Expression.h"
#include "SynTree/Statement.h"

namespace Tuples {
	class FunctionChecker : public Mutator {
		typedef Mutator Parent;
	  public:
		FunctionChecker( bool _topLevel = false, UniqueName *_nameGen = 0 );
		~FunctionChecker();

		virtual Expression* mutate(ApplicationExpr *applicationExpr);
		virtual Statement* mutate(ExprStmt *exprStmt);
	  private:
		bool topLevel;
		UniqueName *nameGen;
		std::list< ObjectDecl * > temporaries;
		std::list< Expression * > tempExpr;
	};

	class TupleDistrib : public Mutator {
	  public:
		virtual Expression* mutate(UntypedExpr *utExpr);
	  private:
	};

	void checkFunctions( std::list< Declaration * > translationUnit );
} // namespace Tuples

#endif // _TUPLE_FUNCHK_H_

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
