//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AssignExpand.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 11:25:53 2015
// Update Count     : 3
//

#ifndef _ASSIGN_EXPAND_H_
#define _ASSIGN_EXPAND_H_

#include <cstdlib>

#include "SynTree/Mutator.h"
#include "SynTree/Statement.h"
#include "SynTree/Expression.h"

#include "Common/UniqueName.h"

namespace Tuples {
	class AssignExpander : public Mutator {
		typedef Mutator Parent;
	  public:
		AssignExpander();
		virtual Statement *mutate( ExprStmt *expr );
		virtual Expression *mutate( SolvedTupleExpr *tupleExpr );
	  private:
		std::list<Statement *> extra, extra2;
		std::list<Expression *> replace;
		UniqueName temporaryNamer;
	};
} // namespace Tuples


#endif // _ASSIGN_EXPAND_H_

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
